/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileConsumerExtendedAttributesTest
extends ContextTestSupport {
    private static final String FILE = "attributes.txt";

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Files.createFile(this.testDirectory().resolve(Path.of("basic", FILE)), new FileAttribute[0]);
        Files.createFile(this.testDirectory().resolve(Path.of("basic-as-default", FILE)), new FileAttribute[0]);
        Files.createFile(this.testDirectory().resolve(Path.of("basic-as-default-with-filter", FILE)), new FileAttribute[0]);
        Files.createFile(this.testDirectory().resolve(Path.of("posix", FILE)), new FileAttribute[0]);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.fromF("file://%s/basic?initialDelay=0&delay=10&extendedAttributes=basic:*", new Object[]{FileConsumerExtendedAttributesTest.this.testDirectory()}).convertBodyTo(String.class)).to("mock:basic");
                ((RouteDefinition)this.fromF("file://%s/basic-as-default?initialDelay=0&delay=10&extendedAttributes=*", new Object[]{FileConsumerExtendedAttributesTest.this.testDirectory()}).convertBodyTo(String.class)).to("mock:basic-as-default");
                ((RouteDefinition)this.fromF("file://%s/basic-as-default-with-filter?initialDelay=0&delay=10&extendedAttributes=size,lastModifiedTime,lastAccessTime", new Object[]{FileConsumerExtendedAttributesTest.this.testDirectory()}).convertBodyTo(String.class)).to("mock:basic-as-default-with-filter");
                ((RouteDefinition)this.fromF("file://%s/posix?initialDelay=0&delay=10&extendedAttributes=posix:*", new Object[]{FileConsumerExtendedAttributesTest.this.testDirectory()}).convertBodyTo(String.class)).to("mock:posix");
            }
        };
    }

    @Test
    public void testBasicAttributes() throws Exception {
        this.testAttributes("mock:basic", "basic:");
    }

    @Test
    public void testBasicAttributesAsDefault() throws Exception {
        this.testAttributes("mock:basic-as-default", "basic:");
    }

    @Test
    public void testBasicAttributesAsDefaultWithFilter() throws Exception {
        this.testAttributes("mock:basic-as-default", "basic:");
    }

    @Test
    public void testPosixAttributes() throws Exception {
        if (FileUtil.isWindows()) {
            return;
        }
        this.testAttributes("mock:posix", "posix:");
    }

    private void testAttributes(String mockEndpoint, String prefix) throws Exception {
        MockEndpoint mock = this.getMockEndpoint(mockEndpoint);
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).header("CamelFileExtendedAttributes")).isNotNull();
        ((MockValueBuilder)mock.message(0).header("CamelFileExtendedAttributes")).convertTo(Map.class);
        this.assertMockEndpointsSatisfied();
        Map attributes = (Map)((Exchange)mock.getExchanges().get(0)).getIn().getHeader("CamelFileExtendedAttributes", Map.class);
        Assertions.assertNotNull((Object)attributes);
        Assertions.assertFalse((boolean)attributes.isEmpty());
        for (Map.Entry entry : attributes.entrySet()) {
            Assertions.assertTrue((boolean)((String)entry.getKey()).startsWith(prefix));
        }
    }
}

