/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumerExcludeNameTest
extends ContextTestSupport {
    @Test
    public void testExcludePreAndPostfixes() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Reports1", "Reports2", "Reports3"});
        this.prepareFiles();
        this.assertMockEndpointsSatisfied();
    }

    private void prepareFiles() {
        String url = this.fileUri();
        this.template.sendBodyAndHeader(url, (Object)"Hello World", "CamelFileName", (Object)"hello.xml");
        this.template.sendBodyAndHeader(url, (Object)"Reports1", "CamelFileName", (Object)"report1.txt");
        this.template.sendBodyAndHeader(url, (Object)"Bye World", "CamelFileName", (Object)"secret.txt");
        this.template.sendBodyAndHeader(url, (Object)"Reports2", "CamelFileName", (Object)"report2.txt");
        this.template.sendBodyAndHeader(url, (Object)"Reports3", "CamelFileName", (Object)"Report3.txt");
        this.template.sendBodyAndHeader(url, (Object)"Secret2", "CamelFileName", (Object)"Secret2.txt");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerExcludeNameTest.this.fileUri("?initialDelay=0&delay=10&exclude=^secret.*|.*xml$")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

