/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumerDirectoryNotMatchedTest
extends ContextTestSupport {
    @Test
    public void testSkipDirectories() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"This is a dot file", "CamelFileName", (Object)".skipme");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"This is a web file", "CamelFileName", (Object)"index.html");
        this.template.sendBodyAndHeader(this.fileUri("2007"), (Object)"2007 report", "CamelFileName", (Object)"report2007.txt");
        this.template.sendBodyAndHeader(this.fileUri("2008"), (Object)"2008 report", "CamelFileName", (Object)"report2008.txt");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerDirectoryNotMatchedTest.this.fileUri("?initialDelay=0&delay=10&recursive=true&include=.*txt$")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

