/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerDirectoryFilterTest
extends ContextTestSupport {
    private final Set<String> names = new TreeSet<String>();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myFilter", new MyDirectoryFilter());
        return jndi;
    }

    @Test
    public void testFilterFilesWithARegularFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri("skipDir/"), (Object)"This is a file to be filtered", "CamelFileName", (Object)"skipme.txt");
        this.template.sendBodyAndHeader(this.fileUri("skipDir2/"), (Object)"This is a file to be filtered", "CamelFileName", (Object)"skipme.txt");
        this.template.sendBodyAndHeader(this.fileUri("okDir/"), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        mock.assertIsSatisfied();
        Assertions.assertEquals((int)4, (int)this.names.size());
        ArrayList<String> list = new ArrayList<String>(this.names);
        list.sort(null);
        Assertions.assertEquals((Object)"okDir", list.get(0));
        Assertions.assertTrue((((String)list.get(1)).equals("okDir/hello.txt") || ((String)list.get(1)).equals("okDir\\hello.txt") ? 1 : 0) != 0, (String)((String)list.get(0)));
        Assertions.assertEquals((Object)"skipDir", list.get(2));
        Assertions.assertEquals((Object)"skipDir2", list.get(3));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerDirectoryFilterTest.this.fileUri("?recursive=true&filter=#myFilter&initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    public class MyDirectoryFilter<T>
    implements GenericFileFilter<T> {
        public boolean accept(GenericFile<T> file) {
            FileConsumerDirectoryFilterTest.this.names.add(file.getFileName());
            return !file.isDirectory() || !file.getFileName().startsWith("skip");
        }
    }
}

