/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.engine.PooledExchangeFactory;
import org.apache.camel.spi.ExchangeFactory;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerDeleteExchangePooledTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        ExtendedCamelContext extendedCamelContext = context.getCamelContextExtension();
        extendedCamelContext.getExchangeFactoryManager().setStatisticsEnabled(true);
        PooledExchangeFactory pef = new PooledExchangeFactory();
        extendedCamelContext.setExchangeFactory((ExchangeFactory)pef);
        extendedCamelContext.getExchangeFactory().setStatisticsEnabled(true);
        extendedCamelContext.getProcessorExchangeFactory().setStatisticsEnabled(true);
        return context;
    }

    @Test
    public void testDelete() throws Exception {
        ExtendedCamelContext ecc = this.context.getCamelContextExtension();
        Assertions.assertEquals((long)0L, (long)ecc.getExchangeFactoryManager().getStatistics().getReleasedCounter());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertEquals((long)1L, (long)ecc.getExchangeFactoryManager().getStatistics().getReleasedCounter()));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileConsumerDeleteExchangePooledTest.this.fileUri("?delete=true&initialDelay=0&delay=10")).to("mock:result");
            }
        };
    }
}

