/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumerDeleteAndFailureTest
extends ContextTestSupport {
    @Test
    public void testMoveFailed() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World IS processed!"});
        mock.expectedFileExists(this.testFile("error/bye.txt"));
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Kaboom", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).handled(true).useOriginalMessage().to(FileConsumerDeleteAndFailureTest.this.fileUri("error"));
                ((RouteDefinition)((RouteDefinition)this.from(FileConsumerDeleteAndFailureTest.this.fileUri("?delete=true&initialDelay=0&delay=10")).setBody((Expression)this.simple("${body} IS processed!"))).process(new Processor(){

                    public void process(Exchange exchange) {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if (body != null && body.startsWith("Kaboom")) {
                            throw new IllegalArgumentException("Forced");
                        }
                    }
                })).to("mock:result");
            }
        };
    }
}

