/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerCustomSchedulerTest
extends ContextTestSupport {
    private final MyScheduler scheduler = new MyScheduler();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myScheduler", (Object)this.scheduler);
        return jndi;
    }

    @Test
    public void testCustomScheduler() throws Exception {
        this.getMockEndpoint("mock:result").expectedMinimumMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.context.getRouteController().startRoute("foo");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.scheduler.getCounter());
        Assertions.assertEquals((Object)"bar", (Object)this.scheduler.getFoo());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileConsumerCustomSchedulerTest.this.fileUri("?scheduler=#myScheduler&scheduler.foo=bar&initialDelay=0&delay=10")).routeId("foo").autoStartup(false).to("mock:result");
            }
        };
    }

    private static final class MyScheduler
    implements ScheduledPollConsumerScheduler {
        private CamelContext camelContext;
        private TimerTask timerTask;
        private final LongAdder counter = new LongAdder();
        private String foo;

        private MyScheduler() {
        }

        public void onInit(Consumer consumer) {
        }

        public void scheduleTask(final Runnable task) {
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    counter.increment();
                    task.run();
                }
            };
        }

        public void unscheduleTask() {
        }

        public int getCounter() {
            return this.counter.intValue();
        }

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public void startScheduler() {
            Timer timer = new Timer();
            timer.schedule(this.timerTask, 10L);
        }

        public boolean isSchedulerStarted() {
            return true;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void shutdown() {
            this.timerTask.cancel();
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

