/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.FileWriter;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerCommitRenameStrategyTest
extends ContextTestSupport {
    @Test
    public void testRenameSuccess() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedBodiesReceived(new Object[]{"Hello Paris"});
        mock.expectedFileExists(this.testFile("done/paris.txt"), "Hello Paris");
        this.template.sendBodyAndHeader(this.fileUri("reports"), (Object)"Hello Paris", "CamelFileName", (Object)"paris.txt");
        this.context.getRouteController().startAllRoutes();
        mock.assertIsSatisfied(1000L);
    }

    @Test
    public void testRenameFileExists() throws Exception {
        this.testDirectory("done", true);
        try (FileWriter fw = new FileWriter(this.testFile("done/london.txt").toFile());){
            fw.write("I was there once in London");
            fw.flush();
        }
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedBodiesReceived(new Object[]{"Hello London"});
        this.template.sendBodyAndHeader(this.fileUri("reports"), (Object)"Hello London", "CamelFileName", (Object)"london.txt");
        this.context.getRouteController().startAllRoutes();
        mock.assertIsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        String content = IOConverter.toString((File)this.testFile("done/london.txt").toFile(), null);
        Assertions.assertEquals((Object)"Hello London", (Object)content, (String)"The file should have been renamed replacing any existing files");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerCommitRenameStrategyTest.this.fileUri("reports?move=../done/${file:name}&initialDelay=0&delay=10")).autoStartup(false).convertBodyTo(String.class)).to("mock:report");
            }
        };
    }
}

