/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumerCommitRenameAbsolutePathStrategyTest
extends ContextTestSupport {
    @Test
    public void testRenameSuccess() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedBodiesReceived(new Object[]{"Hello Paris"});
        mock.expectedFileExists(this.testFile("done/paris.txt"), "Hello Paris");
        this.template.sendBodyAndHeader(this.fileUri("reports"), (Object)"Hello Paris", "CamelFileName", (Object)"paris.txt");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerCommitRenameAbsolutePathStrategyTest.this.fileUri("reports?move=" + String.valueOf(FileConsumerCommitRenameAbsolutePathStrategyTest.this.testDirectory("done").toAbsolutePath()) + "/${file:name}&initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:report");
            }
        };
    }
}

