/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerBridgeRouteExceptionHandlerTest
extends ContextTestSupport {
    private final MyReadLockStrategy myReadLockStrategy = new MyReadLockStrategy();

    @Test
    public void testCustomExceptionHandler() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Error Forced to simulate no space on device"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.myReadLockStrategy.getCounter(), (String)"Should pickup bye.txt file 2 times");
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myReadLockStrategy", (Object)this.myReadLockStrategy);
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)((OnExceptionDefinition)this.onException(IOException.class).handled(true).log("IOException occurred due: ${exception.message}")).transform().simple("Error ${exception.message}")).to("mock:error");
                ((RouteDefinition)this.from(FileConsumerBridgeRouteExceptionHandlerTest.this.fileUri("?exclusiveReadLockStrategy=#myReadLockStrategy&bridgeErrorHandler=true&initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    private static class MyReadLockStrategy
    implements GenericFileExclusiveReadLockStrategy<File> {
        private int counter;

        private MyReadLockStrategy() {
        }

        public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) {
        }

        public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
            if (file.getFileNameOnly().equals("bye.txt") && this.counter++ == 0) {
                throw new IOException("Forced to simulate no space on device");
            }
            return true;
        }

        public void releaseExclusiveReadLockOnAbort(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) {
        }

        public void releaseExclusiveReadLockOnRollback(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) {
        }

        public void releaseExclusiveReadLockOnCommit(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) {
        }

        public void setTimeout(long timeout) {
        }

        public void setCheckInterval(long checkInterval) {
        }

        public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        }

        public void setMarkerFiler(boolean markerFile) {
        }

        public void setDeleteOrphanLockFiles(boolean deleteOrphanLockFiles) {
        }

        public int getCounter() {
            return this.counter;
        }
    }
}

