/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.FileWriter;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerBeginRenameStrategyTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME_1 = "paris" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_2 = "london" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testRenameSuccess() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello Paris"});
        this.template.sendBodyAndHeader(this.fileUri("reports"), (Object)"Hello Paris", "CamelFileName", (Object)TEST_FILE_NAME_1);
        mock.assertIsSatisfied();
    }

    @Test
    public void testRenameFileExists() throws Exception {
        this.testDirectory("inprogress", true);
        try (FileWriter fw = new FileWriter(this.testFile("inprogress/" + TEST_FILE_NAME_2).toFile());){
            fw.write("I was there once in London");
            fw.flush();
        }
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedBodiesReceived(new Object[]{"Hello London"});
        this.template.sendBodyAndHeader(this.fileUri("reports"), (Object)"Hello London", "CamelFileName", (Object)TEST_FILE_NAME_2);
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerBeginRenameStrategyTest.this.fileUri("reports?preMove=../inprogress/${file:name}&initialDelay=0&delay=10")).process(new Processor(){

                    public void process(Exchange exchange) {
                        GenericFile file = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
                        Assertions.assertNotNull((Object)file);
                        Assertions.assertTrue((boolean)file.getRelativeFilePath().contains("inprogress"));
                    }
                })).to("mock:report");
            }
        };
    }
}

