/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerBeginAndCommitRenameStrategyTest
extends ContextTestSupport {
    @Test
    public void testRenameSuccess() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello Paris"});
        mock.expectedFileExists(this.testFile("done/paris.txt"), "Hello Paris");
        this.template.sendBodyAndHeader(this.fileUri("reports"), (Object)"Hello Paris", "CamelFileName", (Object)"paris.txt");
        mock.assertIsSatisfied();
    }

    @Test
    public void testIllegalOptions() {
        Endpoint ep1 = this.context.getEndpoint(this.fileUri("?move=../done/${file:name}&delete=true"));
        Endpoint ep2 = this.context.getEndpoint(this.fileUri("?move=${file:name.noext}.bak&delete=true"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ep1.createConsumer(exchange -> {}), (String)"Should have thrown an exception");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ep2.createConsumer(exchange -> {}), (String)"Should have thrown an exception");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerBeginAndCommitRenameStrategyTest.this.fileUri("reports?preMove=../inprogress/${file:name}&move=../done/${file:name}&initialDelay=0&delay=10")).process(new Processor(){

                    public void process(Exchange exchange) {
                        GenericFile file = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
                        Assertions.assertNotNull((Object)file);
                        Assertions.assertTrue((boolean)file.getRelativeFilePath().contains("inprogress"));
                    }
                })).to("mock:report");
            }
        };
    }
}

