/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumerBatchTest
extends ContextTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerBatchTest.this.fileUri("?initialDelay=0&delay=10")).autoStartup(false).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    @Test
    public void testConsumeBatch() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        ((MockValueBuilder)mock.message(0).exchangeProperty("CamelBatchSize")).isEqualTo((Object)2);
        ((MockValueBuilder)mock.message(0).exchangeProperty("CamelBatchIndex")).isEqualTo((Object)0);
        ((MockValueBuilder)mock.message(1).exchangeProperty("CamelBatchIndex")).isEqualTo((Object)1);
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }
}

