/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerAutoCreateDirectoryTest
extends ContextTestSupport {
    @Test
    public void testCreateDirectory() throws Exception {
        Endpoint endpoint = this.context.getEndpoint(this.fileUri("foo"));
        Consumer consumer = endpoint.createConsumer(new Processor(){

            public void process(Exchange exchange) {
            }
        });
        consumer.start();
        consumer.stop();
        Assertions.assertTrue((boolean)Files.exists(this.testDirectory("foo"), new LinkOption[0]), (String)"Directory should be created");
        Assertions.assertTrue((boolean)Files.isDirectory(this.testDirectory("foo"), new LinkOption[0]), (String)"Directory should be a directory");
    }

    @Test
    public void testCreateAbsoluteDirectory() throws Exception {
        String base = this.testDirectory("foo").toAbsolutePath().toString();
        Endpoint endpoint = this.context.getEndpoint("file://" + base);
        Consumer consumer = endpoint.createConsumer(new Processor(){

            public void process(Exchange exchange) {
            }
        });
        consumer.start();
        consumer.stop();
        Assertions.assertTrue((boolean)Files.exists(this.testDirectory("foo"), new LinkOption[0]), (String)"Directory should be created");
        Assertions.assertTrue((boolean)Files.isDirectory(this.testDirectory("foo"), new LinkOption[0]), (String)"Directory should be a directory");
    }

    @Test
    public void testDoNotCreateDirectory() throws Exception {
        Endpoint endpoint = this.context.getEndpoint(this.fileUri("foo?autoCreate=false"));
        Consumer consumer = endpoint.createConsumer(new Processor(){

            public void process(Exchange exchange) {
            }
        });
        consumer.start();
        consumer.stop();
        Assertions.assertFalse((boolean)Files.exists(this.testDirectory("foo"), new LinkOption[0]), (String)"Directory should NOT be created");
    }

    @Test
    public void testAutoCreateDirectoryWithDot() throws Exception {
        Endpoint endpoint = this.context.getEndpoint(this.fileUri("foo.bar?autoCreate=true"));
        Consumer consumer = endpoint.createConsumer(new Processor(){

            public void process(Exchange exchange) {
            }
        });
        consumer.start();
        consumer.stop();
        Assertions.assertTrue((boolean)Files.exists(this.testDirectory("foo.bar"), new LinkOption[0]), (String)"Directory should be created");
        Assertions.assertTrue((boolean)Files.isDirectory(this.testDirectory("foo.bar"), new LinkOption[0]), (String)"Directory should be a directory");
    }

    @Test
    public void testStartingDirectoryMustExistDirectory() {
        Endpoint endpoint = this.context.getEndpoint(this.fileUri("foo?autoCreate=false&startingDirectoryMustExist=true"));
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            Consumer c = endpoint.createConsumer(exchange -> {});
            c.start();
        }, (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e.getCause().getMessage().startsWith("Starting directory does not exist"));
        Assertions.assertFalse((boolean)Files.exists(this.testDirectory("foo"), new LinkOption[0]), (String)"Directory should NOT be created");
    }
}

