/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumerAbsolutePathWithRelativeMoveTest
extends ContextTestSupport {
    @Test
    public void testConsumeFromAbsolutePath() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedBodiesReceived(new Object[]{"Hello Paris"});
        mock.expectedFileExists(this.testDirectory("dir").resolve("../done/paris.txt"));
        this.template.sendBodyAndHeader(this.fileUri("dir"), (Object)"Hello Paris", "CamelFileName", (Object)"paris.txt");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("file://" + String.valueOf(FileConsumerAbsolutePathWithRelativeMoveTest.this.testDirectory("dir").toAbsolutePath()) + "?initialDelay=0&delay=10&move=../done/${file:onlyname}").convertBodyTo(String.class)).to("mock:report");
            }
        };
    }
}

