/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class FileConsumerAbsolutePathDefaultMoveTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "paris" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testConsumeFromAbsolutePath() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedBodiesReceived(new Object[]{"Hello Paris"});
        mock.expectedFileExists(this.testFile(".camel/" + TEST_FILE_NAME));
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).pollDelay(250L, TimeUnit.MILLISECONDS).untilAsserted(() -> {
            this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello Paris", "CamelFileName", (Object)TEST_FILE_NAME);
            this.assertMockEndpointsSatisfied();
        });
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerAbsolutePathDefaultMoveTest.this.fileUri("?initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:report");
            }
        };
    }
}

