/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumeSimpleRelativeMoveToRelativeTest
extends ContextTestSupport {
    @Test
    public void testMoveToSubDir() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        mock.expectedFileExists(this.testFile(".done/bye.txt"));
        mock.expectedFileExists(this.testFile("sub/.done/hello.txt"));
        mock.expectedFileExists(this.testFile("sub/sub2/.done/goodday.txt"));
        String fileUrl = this.fileUri();
        this.template.sendBodyAndHeader(fileUrl, (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader(fileUrl, (Object)"Hello World", "CamelFileName", (Object)"sub/hello.txt");
        this.template.sendBodyAndHeader(fileUrl, (Object)"Goodday World", "CamelFileName", (Object)"sub/sub2/goodday.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeSimpleRelativeMoveToRelativeTest.this.fileUri("?recursive=true&move=.done&initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

