/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumeSimpleRelativeMoveToAbsoluteTest
extends ContextTestSupport {
    @Test
    public void testMoveToSubDir() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        mock.expectedFileExists(this.testFile(".done/bye.txt"));
        mock.expectedFileExists(this.testFile(".done/hello.txt"));
        mock.expectedFileExists(this.testFile(".done/goodday.txt"));
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"sub/hello.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Goodday World", "CamelFileName", (Object)"sub/sub2/goodday.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        final String base = this.testDirectory(".done").toAbsolutePath().toString();
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeSimpleRelativeMoveToAbsoluteTest.this.fileUri("?recursive=true&move=" + base + "&initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

