/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumeSimpleDynamicDoneFileNameWithTwoDotsTest
extends ContextTestSupport {
    @Test
    public void testSimpleDynamicDoneFileNameContainingTwoDots() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(1).create();
        this.getMockEndpoint("mock:result").expectedBodiesReceivedInAnyOrder(new Object[]{"input-body"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"input-body", "CamelFileName", (Object)"test.twodot.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"done-body", "CamelFileName", (Object)"test.twodot.done");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)notify.matchesWaitTime());
        Assertions.assertFalse((boolean)Files.exists(this.testFile("test.twodot.txt"), new LinkOption[0]), (String)"Input file should be deleted");
        Assertions.assertFalse((boolean)Files.exists(this.testFile("test.twodot.done"), new LinkOption[0]), (String)"Done file should be deleted");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileConsumeSimpleDynamicDoneFileNameWithTwoDotsTest.this.fileUri("?doneFileName=$simple{file:name.noext}.done&initialDelay=0")).to("mock:result");
            }
        };
    }
}

