/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumeSimpleAbsoluteMoveToRelativeTest
extends ContextTestSupport {
    @Test
    public void testMoveToSubDir() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        mock.expectedFileExists(String.valueOf(this.testDirectory()) + "/.done/bye.txt");
        mock.expectedFileExists(String.valueOf(this.testDirectory()) + "/sub/.done/hello.txt");
        mock.expectedFileExists(String.valueOf(this.testDirectory()) + "/sub/sub2/.done/goodday.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"sub/hello.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Goodday World", "CamelFileName", (Object)"sub/sub2/goodday.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeSimpleAbsoluteMoveToRelativeTest.this.fileUri() + "?recursive=true&move=.done&initialDelay=0&delay=10").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

