/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.Test;

public class FileConsumePollEnrichFileUsingProcessorTest
extends ContextTestSupport {
    @Test
    public void testPollEnrich() throws Exception {
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Start"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Big file"});
        mock.expectedFileExists(this.testFile("enrich/.done/AAA.fin"));
        mock.expectedFileExists(this.testFile("enrichdata/.done/AAA.dat"));
        mock.expectedFileExists(this.testFile("enrichdata/BBB.dat"));
        this.template.sendBodyAndHeader(this.fileUri("enrichdata"), (Object)"Big file", "CamelFileName", (Object)"AAA.dat");
        this.template.sendBodyAndHeader(this.fileUri("enrichdata"), (Object)"Other Big file", "CamelFileName", (Object)"BBB.dat");
        this.template.sendBodyAndHeader(this.fileUri("enrich"), (Object)"Start", "CamelFileName", (Object)"AAA.fin");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumePollEnrichFileUsingProcessorTest.this.fileUri("enrich?initialDelay=0&delay=10&move=.done")).process(new Processor(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void process(Exchange exchange) throws Exception {
                        Object name = (String)exchange.getIn().getHeader("CamelFileNameOnly", String.class);
                        name = FileUtil.stripExt((String)name) + ".dat";
                        Exchange data = null;
                        ConsumerTemplate con = exchange.getContext().createConsumerTemplate();
                        try {
                            data = con.receive(FileConsumePollEnrichFileUsingProcessorTest.this.fileUri("enrichdata?initialDelay=0&delay=10&move=.done&fileName=" + (String)name), 5000L);
                        }
                        finally {
                            con.stop();
                        }
                        if (data == null) {
                            throw new CamelExchangeException("Cannot find the data file " + (String)name, exchange);
                        }
                        FileConsumePollEnrichFileUsingProcessorTest.this.template.send("direct:data", data);
                    }
                })).to("mock:start");
                this.from("direct:data").to("mock:result");
            }
        };
    }
}

