/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class FileConsumePollEnrichFileTest
extends ContextTestSupport {
    @Test
    public void testPollEnrich() {
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Start"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Big file"});
        mock.expectedFileExists(this.testFile("enrich/.done/AAA.fin"));
        mock.expectedFileExists(this.testFile("enrichdata/.done/AAA.dat"));
        this.template.sendBodyAndHeader(this.fileUri("enrich"), (Object)"Start", "CamelFileName", (Object)"AAA.fin");
        this.log.info("Sleeping for 1/4 sec before writing enrichdata file");
        Awaitility.await().pollDelay(250L, TimeUnit.MILLISECONDS).untilAsserted(() -> {
            this.template.sendBodyAndHeader(this.fileUri("enrichdata"), (Object)"Big file", "CamelFileName", (Object)"AAA.dat");
            this.log.info("... write done");
            this.assertMockEndpointsSatisfied();
        });
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from(FileConsumePollEnrichFileTest.this.fileUri("enrich?initialDelay=0&delay=10&move=.done")).to("mock:start")).pollEnrich(FileConsumePollEnrichFileTest.this.fileUri("enrichdata?initialDelay=0&delay=10&move=.done"), 1000L)).to("mock:result");
            }
        };
    }
}

