/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class FileConsumePollEnrichFileIdleEventTest
extends ContextTestSupport {
    @Test
    public void testNonEmptyAfterEmpty() throws Exception {
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Event1", "Event2"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Event1", "EnrichData"});
        mock.expectedFileExists(this.testFile("enrich/.done/Event1.txt"));
        mock.expectedFileExists(this.testFile("enrich/.done/Event2.txt"));
        mock.expectedFileExists(this.testFile("enrichdata/.done/AAA.dat"));
        this.template.sendBodyAndHeader(this.fileUri("enrich"), (Object)"Event1", "CamelFileName", (Object)"Event1.txt");
        this.context.getRouteController().startAllRoutes();
        this.log.info("Sleeping for 1 sec before writing enrichdata file");
        Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            this.template.sendBodyAndHeader(this.fileUri("enrichdata"), (Object)"EnrichData", "CamelFileName", (Object)"AAA.dat");
            this.template.sendBodyAndHeader(this.fileUri("enrich"), (Object)"Event2", "CamelFileName", (Object)"Event2.txt");
            this.log.info("... write done");
            this.assertMockEndpointsSatisfied();
        });
    }

    @Test
    public void testPollEmptyEnrich() throws Exception {
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Event3"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Event3"});
        mock.expectedFileExists(this.testFile("enrich/.done/Event3.txt"));
        this.template.sendBodyAndHeader(this.fileUri("enrich"), (Object)"Event3", "CamelFileName", (Object)"Event3.txt");
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from(FileConsumePollEnrichFileIdleEventTest.this.fileUri("enrich?initialDelay=0&delay=10&move=.done")).autoStartup(false).to("mock:start")).pollEnrich(FileConsumePollEnrichFileIdleEventTest.this.fileUri("enrichdata?initialDelay=0&delay=10&move=.done&sendEmptyMessageWhenIdle=true"), 1000L)).to("mock:result");
            }
        };
    }
}

