/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class FileConsumeNotEagerMaxMessagesPerPollTest
extends ContextTestSupport {
    @Test
    public void testMaxMessagesPerPoll() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"AAA", "BBB"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"CCC", "CamelFileName", (Object)"ccc.FileConsumeNotEagerMaxMessagesPerPollTest.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"AAA", "CamelFileName", (Object)"aaa.FileConsumeNotEagerMaxMessagesPerPollTest.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"BBB", "CamelFileName", (Object)"bbb.FileConsumeNotEagerMaxMessagesPerPollTest.txt");
        this.context.getRouteController().startRoute("foo");
        mock.expectedPropertyReceived("CamelBatchSize", (Object)2);
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"CCC"});
        mock.expectedPropertyReceived("CamelBatchSize", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeNotEagerMaxMessagesPerPollTest.this.fileUri("?initialDelay=0&delay=10&maxMessagesPerPoll=2&eagerMaxMessagesPerPoll=false&sortBy=file:name")).routeId("foo").autoStartup(false).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

