/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumeMultipleDirectoriesTest
extends ContextTestSupport {
    public static final String FILE_QUERY = "?initialDelay=0&delay=10&recursive=true&delete=true&sortBy=file:path";

    @Test
    public void testMultiDir() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World", "Hello World", "Godday World"});
        String fileUri = this.fileUri(FILE_QUERY);
        this.template.sendBodyAndHeader(fileUri, (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader(fileUri, (Object)"Hello World", "CamelFileName", (Object)"sub/hello.txt");
        this.template.sendBodyAndHeader(fileUri, (Object)"Godday World", "CamelFileName", (Object)"sub/sub2/godday.txt");
        this.assertMockEndpointsSatisfied();
        Exchange exchange = (Exchange)mock.getExchanges().get(0);
        GenericFile gf = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
        File file = (File)gf.getFile();
        FileConsumeMultipleDirectoriesTest.assertDirectoryEquals(this.testFile("bye.txt").toString(), file.getPath());
        Assertions.assertEquals((Object)"bye.txt", (Object)file.getName());
        exchange = (Exchange)mock.getExchanges().get(1);
        gf = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
        file = (File)gf.getFile();
        FileConsumeMultipleDirectoriesTest.assertDirectoryEquals(this.testFile("sub/hello.txt").toString(), file.getPath());
        Assertions.assertEquals((Object)"hello.txt", (Object)file.getName());
        exchange = (Exchange)mock.getExchanges().get(2);
        gf = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
        file = (File)gf.getFile();
        FileConsumeMultipleDirectoriesTest.assertDirectoryEquals(this.testFile("sub/sub2/godday.txt").toString(), file.getPath());
        Assertions.assertEquals((Object)"godday.txt", (Object)file.getName());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeMultipleDirectoriesTest.this.fileUri(FileConsumeMultipleDirectoriesTest.FILE_QUERY)).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

