/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumeMoveRelativeNameTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME_PREFIX = UUID.randomUUID().toString();
    public static final String FILE_QUERY = "?initialDelay=0&delay=10&recursive=true&move=.done/${file:name}.old";

    @Test
    public void testMultiDir() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Bye World", "Hello World", "Goodday World"});
        mock.expectedFileExists(this.testFile(".done/" + TEST_FILE_NAME_PREFIX + "bye.txt.old"));
        mock.expectedFileExists(this.testFile(".done/" + TEST_FILE_NAME_PREFIX + "sub/hello.txt.old"));
        mock.expectedFileExists(this.testFile(".done/" + TEST_FILE_NAME_PREFIX + "sub/sub2/goodday.txt.old"));
        String fileUrl = this.fileUri(FILE_QUERY);
        this.template.sendBodyAndHeader(fileUrl, (Object)"Bye World", "CamelFileName", (Object)(TEST_FILE_NAME_PREFIX + "bye.txt"));
        this.template.sendBodyAndHeader(fileUrl, (Object)"Hello World", "CamelFileName", (Object)(TEST_FILE_NAME_PREFIX + "sub/hello.txt"));
        this.template.sendBodyAndHeader(fileUrl, (Object)"Goodday World", "CamelFileName", (Object)(TEST_FILE_NAME_PREFIX + "sub/sub2/goodday.txt"));
        this.context.getRouteController().startRoute("foo");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeMoveRelativeNameTest.this.fileUri(FileConsumeMoveRelativeNameTest.FILE_QUERY)).routeId("foo").autoStartup(false).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

