/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumeMaxMessagesPerPollTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME_PREFIX = UUID.randomUUID().toString();
    public static final String FILE_QUERY = "?initialDelay=0&delay=10&maxMessagesPerPoll=2";

    @Test
    public void testMaxMessagesPerPoll() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(2);
        ((MockValueBuilder)mock.message(0).exchangeProperty("CamelBatchSize")).isEqualTo((Object)2);
        ((MockValueBuilder)mock.message(1).exchangeProperty("CamelBatchSize")).isEqualTo((Object)2);
        String fileUri = this.fileUri(FILE_QUERY);
        this.template.sendBodyAndHeader(fileUri, (Object)"Bye World", "CamelFileName", (Object)(TEST_FILE_NAME_PREFIX + "bye.txt"));
        this.template.sendBodyAndHeader(fileUri, (Object)"Hello World", "CamelFileName", (Object)(TEST_FILE_NAME_PREFIX + "hello.txt"));
        this.template.sendBodyAndHeader(fileUri, (Object)"Godday World", "CamelFileName", (Object)(TEST_FILE_NAME_PREFIX + "godday.txt"));
        this.context.getRouteController().startRoute("foo");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeMaxMessagesPerPollTest.this.fileUri(FileConsumeMaxMessagesPerPollTest.FILE_QUERY)).routeId("foo").autoStartup(false).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

