/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumeHiddenFilesTest
extends ContextTestSupport {
    @Test
    public void testConsumeHiddenFiles() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Report 123", "Hidden report 123"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Report 123", "CamelFileName", (Object)"report.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hidden report 123", "CamelFileName", (Object)".report.hidden");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().untilAsserted(() -> {
            Assertions.assertFalse((boolean)Files.exists(this.testFile("report.txt"), new LinkOption[0]), (String)"File should been deleted");
            Assertions.assertFalse((boolean)Files.exists(this.testFile(".report.hidden"), new LinkOption[0]), (String)"File should been deleted");
        });
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeHiddenFilesTest.this.fileUri("?initialDelay=0&delay=10&delete=true&includeHiddenFiles=true")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

