/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumeHiddenDirsTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME_1 = "report1" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_2 = "report2" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testConsumeHiddenDirs() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Report 123", "Report 456"});
        this.template.sendBodyAndHeader(this.fileUri(".hidden"), (Object)"Report 123", "CamelFileName", (Object)TEST_FILE_NAME_1);
        this.template.sendBodyAndHeader(this.fileUri("obvious"), (Object)"Report 456", "CamelFileName", (Object)TEST_FILE_NAME_2);
        this.assertMockEndpointsSatisfied();
        Awaitility.await().untilAsserted(() -> {
            Assertions.assertFalse((boolean)Files.exists(this.testFile(".hidden/" + TEST_FILE_NAME_1), new LinkOption[0]), (String)"File should been deleted");
            Assertions.assertFalse((boolean)Files.exists(this.testFile("obvious/" + TEST_FILE_NAME_2), new LinkOption[0]), (String)"File should been deleted");
        });
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeHiddenDirsTest.this.fileUri("?initialDelay=0&delay=10&delete=true&includeHiddenDirs=true&recursive=true")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

