/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumeFilesAndDeleteTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME_1 = "report" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_2 = "report2" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_3 = "report2008" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testConsumeAndDelete() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME_2);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME_1);
        this.template.sendBodyAndHeader(this.fileUri() + "/2008", (Object)"2008 Report", "CamelFileName", (Object)TEST_FILE_NAME_3);
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertFalse((boolean)Files.exists(this.testFile(TEST_FILE_NAME_1), new LinkOption[0]), (String)"File should been deleted");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeFilesAndDeleteTest.this.fileUri("?initialDelay=0&delay=10&fileName=" + TEST_FILE_NAME_1 + "&delete=true")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

