/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumeDynamicDoneFileNameWithTwoDotsTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME_PREFIX = UUID.randomUUID().toString();

    @Test
    public void testDynamicDoneFileNameContainingTwoDots() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(1).create();
        this.getMockEndpoint("mock:result").expectedBodiesReceivedInAnyOrder(new Object[]{"input-body"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"input-body", "CamelFileName", (Object)(TEST_FILE_NAME_PREFIX + "test.twodot.txt"));
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"done-body", "CamelFileName", (Object)(TEST_FILE_NAME_PREFIX + "test.twodot.done"));
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)notify.matchesWaitTime());
        Assertions.assertFalse((boolean)Files.exists(this.testFile(TEST_FILE_NAME_PREFIX + "test.twodot.txt"), new LinkOption[0]), (String)"Input file should be deleted");
        Assertions.assertFalse((boolean)Files.exists(this.testFile(TEST_FILE_NAME_PREFIX + "test.twodot.txt"), new LinkOption[0]), (String)"Done file should be deleted");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileConsumeDynamicDoneFileNameWithTwoDotsTest.this.fileUri("?doneFileName=${file:name.noext}.done&initialDelay=0")).to("mock:result");
            }
        };
    }
}

