/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class FileConsumeDoneFileIssueTest
extends ContextTestSupport {
    private static final String TEST_DIR_NAME = "done" + UUID.randomUUID().toString();
    private static final String TEST_DIR_NAME_2 = "done2" + UUID.randomUUID().toString();

    @Test
    public void testFileConsumeDoneFileIssue() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(5).create();
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME, (Object)"A", "CamelFileName", (Object)"foo-a.txt");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME, (Object)"B", "CamelFileName", (Object)"foo-b.txt");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME, (Object)"C", "CamelFileName", (Object)"foo-c.txt");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME, (Object)"D", "CamelFileName", (Object)"foo-d.txt");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME, (Object)"E", "CamelFileName", (Object)"foo-e.txt");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME, (Object)"E", "CamelFileName", (Object)"foo.done");
        Assertions.assertTrue((boolean)Files.exists(this.testFile(TEST_DIR_NAME + File.separator + "foo.done"), new LinkOption[0]), (String)"Done file should exists");
        this.getMockEndpoint("mock:result").expectedBodiesReceivedInAnyOrder(new Object[]{"A", "B", "C", "D", "E"});
        this.context.getRouteController().startRoute("foo");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)notify.matchesWaitTime());
        Awaitility.await().atLeast(50L, TimeUnit.MILLISECONDS).untilAsserted(() -> Assertions.assertFalse((boolean)Files.exists(this.testFile(TEST_DIR_NAME + File.separator + "foo.done"), new LinkOption[0]), (String)"Done file should be deleted"));
    }

    @Test
    public void testFileConsumeDynamicDoneFileName() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(3).create();
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME_2, (Object)"A", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME_2, (Object)"B", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME_2, (Object)"C", "CamelFileName", (Object)"c.txt");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME_2, (Object)"a", "CamelFileName", (Object)"a.txt.done");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME_2, (Object)"b", "CamelFileName", (Object)"b.txt.done");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME_2, (Object)"c", "CamelFileName", (Object)"c.txt.done");
        Assertions.assertTrue((boolean)Files.exists(this.testFile(TEST_DIR_NAME_2 + File.separator + "a.txt.done"), new LinkOption[0]), (String)"Done file should exists");
        Assertions.assertTrue((boolean)Files.exists(this.testFile(TEST_DIR_NAME_2 + File.separator + "b.txt.done"), new LinkOption[0]), (String)"Done file should exists");
        Assertions.assertTrue((boolean)Files.exists(this.testFile(TEST_DIR_NAME_2 + File.separator + "c.txt.done"), new LinkOption[0]), (String)"Done file should exists");
        this.getMockEndpoint("mock:result").expectedBodiesReceivedInAnyOrder(new Object[]{"A", "B", "C"});
        this.context.getRouteController().startRoute("bar");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)notify.matchesWaitTime());
        Awaitility.await().atLeast(50L, TimeUnit.MILLISECONDS).untilAsserted(() -> Assertions.assertFalse((boolean)Files.exists(this.testFile(TEST_DIR_NAME_2 + File.separator + "a.txt.done"), new LinkOption[0]), (String)"Done file should be deleted"));
        Assertions.assertFalse((boolean)Files.exists(this.testFile(TEST_DIR_NAME_2 + File.separator + "b.txt.done"), new LinkOption[0]), (String)"Done file should be deleted");
        Assertions.assertFalse((boolean)Files.exists(this.testFile(TEST_DIR_NAME_2 + File.separator + "c.txt.done"), new LinkOption[0]), (String)"Done file should be deleted");
    }

    @Test
    public void testFileDoneFileNameContainingDollarSign() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(3).create();
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME_2, (Object)"A", "CamelFileName", (Object)"$a$.txt");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME_2, (Object)"B", "CamelFileName", (Object)"$b.txt");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME_2, (Object)"C", "CamelFileName", (Object)"c$.txt");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME_2, (Object)"a", "CamelFileName", (Object)"$a$.txt.done");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME_2, (Object)"b", "CamelFileName", (Object)"$b.txt.done");
        this.template.sendBodyAndHeader(this.fileUri() + File.separator + TEST_DIR_NAME_2, (Object)"c", "CamelFileName", (Object)"c$.txt.done");
        Assertions.assertTrue((boolean)Files.exists(this.testFile(TEST_DIR_NAME_2 + File.separator + "$a$.txt.done"), new LinkOption[0]), (String)"Done file should exists");
        Assertions.assertTrue((boolean)Files.exists(this.testFile(TEST_DIR_NAME_2 + File.separator + "$b.txt.done"), new LinkOption[0]), (String)"Done file should exists");
        Assertions.assertTrue((boolean)Files.exists(this.testFile(TEST_DIR_NAME_2 + File.separator + "c$.txt.done"), new LinkOption[0]), (String)"Done file should exists");
        this.getMockEndpoint("mock:result").expectedBodiesReceivedInAnyOrder(new Object[]{"A", "B", "C"});
        this.context.getRouteController().startRoute("bar");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)notify.matchesWaitTime());
        Awaitility.await().atLeast(50L, TimeUnit.MILLISECONDS).untilAsserted(() -> Assertions.assertFalse((boolean)Files.exists(this.testFile(TEST_DIR_NAME_2 + File.separator + "$a$.txt.done"), new LinkOption[0]), (String)"Done file should be deleted"));
        Assertions.assertFalse((boolean)Files.exists(this.testFile(TEST_DIR_NAME_2 + File.separator + "$b.txt.done"), new LinkOption[0]), (String)"Done file should be deleted");
        Assertions.assertFalse((boolean)Files.exists(this.testFile(TEST_DIR_NAME_2 + File.separator + "c$.txt.done"), new LinkOption[0]), (String)"Done file should be deleted");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeDoneFileIssueTest.this.fileUri(TEST_DIR_NAME + "?doneFileName=foo.done&initialDelay=0&delay=10")).routeId("foo").autoStartup(false).convertBodyTo(String.class)).to("mock:result");
                ((RouteDefinition)this.from(FileConsumeDoneFileIssueTest.this.fileUri(TEST_DIR_NAME_2 + "?doneFileName=${file:name}.done&initialDelay=0&delay=10")).routeId("bar").autoStartup(false).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

