/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileConsumeCharsetTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "report" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.template.sendBodyAndHeader(this.fileUri("?charset=UTF-8"), (Object)"Hello World \u4f60\u597d", "CamelFileName", (Object)TEST_FILE_NAME);
    }

    @Test
    public void testConsumeAndDelete() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World \u4f60\u597d"});
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertFalse((boolean)Files.exists(this.testFile(TEST_FILE_NAME), new LinkOption[0]), (String)"File should been deleted");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeCharsetTest.this.fileUri("?initialDelay=0&delay=10&fileName=" + TEST_FILE_NAME + "&delete=true&charset=UTF-8")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

