/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileConsumeBackoffMultiplierTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "report" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
    }

    @Test
    public void testBackoffMultiplier() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeBackoffMultiplierTest.this.fileUri() + "?initialDelay=0&delay=10&delete=true&backoffMultiplier=4&backoffIdleThreshold=3").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

