/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumeAlterFileNameHeaderIssueTest
extends ContextTestSupport {
    public static final String TEST_FILE_NAME = "hello." + String.valueOf(UUID.randomUUID()) + ".txt";
    public static final String TEST_FILE_NAME_BYE = "bye." + String.valueOf(UUID.randomUUID()) + ".txt";

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testConsumeAndDeleteRemoveAllHeaders() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeAlterFileNameHeaderIssueTest.this.fileUri() + "?initialDelay=0&delay=10&delete=true").removeHeaders("*")).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertFalse((boolean)((Exchange)mock.getExchanges().get(0)).getIn().hasHeaders(), (String)"Headers should have been removed");
        Assertions.assertFalse((boolean)Files.exists(this.testFile(TEST_FILE_NAME), new LinkOption[0]), (String)"File should been deleted");
    }

    @Test
    public void testConsumeAndDeleteChangeFileHeader() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeAlterFileNameHeaderIssueTest.this.fileUri() + "?initialDelay=0&delay=10&delete=true").setHeader("CamelFileName", (Expression)this.constant(TEST_FILE_NAME_BYE))).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("CamelFileName", (Object)TEST_FILE_NAME_BYE);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertFalse((boolean)Files.exists(this.testFile(TEST_FILE_NAME), new LinkOption[0]), (String)"File should been deleted");
    }

    @Test
    public void testConsumeAndMoveRemoveAllHeaders() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeAlterFileNameHeaderIssueTest.this.fileUri() + "?initialDelay=0&delay=10").removeHeaders("*")).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertFalse((boolean)((Exchange)mock.getExchanges().get(0)).getIn().hasHeaders(), (String)"Headers should have been removed");
        Assertions.assertTrue((boolean)Files.exists(this.testFile(".camel/" + TEST_FILE_NAME), new LinkOption[0]), (String)"File should been moved");
    }

    @Test
    public void testConsumeAndMoveChangeFileHeader() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumeAlterFileNameHeaderIssueTest.this.fileUri() + "?initialDelay=0&delay=10").setHeader("CamelFileName", (Expression)this.constant(TEST_FILE_NAME_BYE))).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("CamelFileName", (Object)TEST_FILE_NAME_BYE);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertTrue((boolean)Files.exists(this.testFile(".camel/" + TEST_FILE_NAME), new LinkOption[0]), (String)"File should been moved");
    }
}

