/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFile;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConfigureTest
extends ContextTestSupport {
    private static final String EXPECT_PATH = "target" + File.separator + "data" + File.separator + "FileConfigureTest" + File.separator + "bar";
    private static final String EXPECT_FILE = "some" + File.separator + "nested" + File.separator + "filename.txt";
    private static final Processor DUMMY_PROCESSOR = new Processor(){

        public void process(Exchange exchange) {
        }
    };

    @Test
    public void testUriConfigurations() {
        this.assertFileEndpoint("file://target/data/FileConfigureTest/bar", EXPECT_PATH, false);
        this.assertFileEndpoint("file://target/data/FileConfigureTest/bar?delete=true", EXPECT_PATH, false);
        this.assertFileEndpoint("file:target/data/FileConfigureTest/bar?delete=true", EXPECT_PATH, false);
        this.assertFileEndpoint("file:target/data/FileConfigureTest/bar", EXPECT_PATH, false);
        this.assertFileEndpoint("file://target/data/FileConfigureTest/bar/", EXPECT_PATH, false);
        this.assertFileEndpoint("file://target/data/FileConfigureTest/bar/?delete=true", EXPECT_PATH, false);
        this.assertFileEndpoint("file:target/data/FileConfigureTest/bar/?delete=true", EXPECT_PATH, false);
        this.assertFileEndpoint("file:target/data/FileConfigureTest/bar/", EXPECT_PATH, false);
        this.assertFileEndpoint("file:/target/data/FileConfigureTest/bar/", File.separator + EXPECT_PATH + File.separator + EXPECT_FILE, true);
        this.assertFileEndpoint("file:/", File.separator, true);
        this.assertFileEndpoint("file:///", File.separator, true);
    }

    @Test
    public void testUriWithParameters() {
        FileEndpoint endpoint = this.resolveMandatoryEndpoint("file:///C:/camel/temp?delay=10&useFixedDelay=true&initialDelay=10&bridgeErrorHandler=true&autoCreate=false&startingDirectoryMustExist=true&directoryMustExist=true&readLock=changed", FileEndpoint.class);
        Assertions.assertNotNull((Object)endpoint, (String)"Could not find file endpoint");
        Assertions.assertTrue((boolean)endpoint.isStartingDirectoryMustExist(), (String)"Get a wrong option of StartingDirectoryMustExist");
        endpoint = this.resolveMandatoryEndpoint("file:///C:/camel/temp?delay=10&useFixedDelay=true&initialDelay=10&startingDirectoryMustExist=true&bridgeErrorHandler=true&autoCreate=false&directoryMustExist=true&readLock=changed", FileEndpoint.class);
        Assertions.assertNotNull((Object)endpoint, (String)"Could not find file endpoint");
        Assertions.assertTrue((boolean)endpoint.isStartingDirectoryMustExist(), (String)"Get a wrong option of StartingDirectoryMustExist");
        endpoint = this.resolveMandatoryEndpoint("file:///C:/camel/temp?delay=10&startingDirectoryMustExist=true&useFixedDelay=true&initialDelay=10&bridgeErrorHandler=true&autoCreate=false&directoryMustExist=true&readLock=changed", FileEndpoint.class);
        Assertions.assertNotNull((Object)endpoint, (String)"Could not find file endpoint");
        Assertions.assertTrue((boolean)endpoint.isStartingDirectoryMustExist(), (String)"Get a wrong option of StartingDirectoryMustExist");
        endpoint = this.resolveMandatoryEndpoint("file:///C:/camel/temp?delay=10&useFixedDelay=true&initialDelay=10", FileEndpoint.class);
        Assertions.assertNotNull((Object)endpoint, (String)"Could not find file endpoint");
        Assertions.assertFalse((boolean)endpoint.isStartingDirectoryMustExist(), (String)"Get a wrong option of StartingDirectoryMustExist");
    }

    @Test
    public void testUriWithCharset() {
        FileEndpoint endpoint = this.resolveMandatoryEndpoint("file://target/data/FileConfigureTest/bar?charset=UTF-8", FileEndpoint.class);
        Assertions.assertNotNull((Object)endpoint, (String)"Could not find endpoint: file://target/data/FileConfigureTest/bar?charset=UTF-8");
        Assertions.assertEquals((Object)"UTF-8", (Object)endpoint.getCharset(), (String)"Get a wrong charset");
        Exception ex = (Exception)Assertions.assertThrows(Exception.class, () -> this.resolveMandatoryEndpoint("file://target/data/FileConfigureTest/bar?charset=ASSI", FileEndpoint.class), (String)"Expect a configure exception here");
        boolean b = ex instanceof ResolveEndpointFailedException;
        Assertions.assertTrue((boolean)b, (String)"Get the wrong exception type here");
    }

    @Test
    public void testConsumerConfigurations() throws Exception {
        FileConsumer consumer = this.createFileConsumer("file://target/data/FileConfigureTest/bar?recursive=true");
        Assertions.assertNotNull((Object)consumer);
        Exception ex = (Exception)Assertions.assertThrows(Exception.class, () -> this.createFileConsumer("file://target/data/FileConfigureTest/bar?recursiv=true"), (String)"Expect a configure exception here");
        boolean b = ex instanceof ResolveEndpointFailedException;
        Assertions.assertTrue((boolean)b, (String)"Get the wrong exception type here");
    }

    private FileConsumer createFileConsumer(String endpointUri) throws Exception {
        FileEndpoint endpoint = this.resolveMandatoryEndpoint(endpointUri, FileEndpoint.class);
        return endpoint.createConsumer(DUMMY_PROCESSOR);
    }

    private void assertFileEndpoint(String endpointUri, String expectedPath, boolean absolute) {
        FileEndpoint endpoint = this.resolveMandatoryEndpoint(endpointUri, FileEndpoint.class);
        Assertions.assertNotNull((Object)endpoint, (String)("Could not find endpoint: " + endpointUri));
        if (!absolute) {
            File file = endpoint.getFile();
            String path = file.getPath();
            FileConfigureTest.assertDirectoryEquals("For uri: " + endpointUri + " the file is not equal", expectedPath, path);
            file = new File(expectedPath + (expectedPath.endsWith(File.separator) ? "" : File.separator) + EXPECT_FILE);
            GenericFile consumedFile = FileConsumer.asGenericFile((String)endpoint.getFile().getPath(), (File)file, null, (boolean)false);
            Assertions.assertEquals((Object)EXPECT_FILE, (Object)consumedFile.getRelativeFilePath());
        }
    }
}

