/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Isolated
public class FileConcurrentWriteAppendSameFileTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "input" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_RESULT = "result" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final Logger LOG = LoggerFactory.getLogger(FileConcurrentWriteAppendSameFileTest.class);
    private final int size = 100;
    private String data;

    @BeforeEach
    void setUpData() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            sb.append("Line ").append(i).append(LS);
        }
        this.data = sb.toString();
    }

    private boolean fileIsOk() {
        Path path = this.testFile("outbox/" + TEST_FILE_NAME_RESULT);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                long expectedSize = 1790L;
                return Files.size(path) == 1790L;
            }
            catch (IOException e) {
                LOG.error("IOException: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return false;
    }

    @Test
    public void testConcurrentAppend() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)this.data, "CamelFileName", (Object)TEST_FILE_NAME);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(100);
        mock.expectsNoDuplicates((Expression)FileConcurrentWriteAppendSameFileTest.body());
        mock.setResultWaitTime(30000L);
        this.context.getRouteController().startRoute("foo");
        Awaitility.await().atMost(1000L, TimeUnit.MILLISECONDS).until(this::fileIsOk);
        this.assertMockEndpointsSatisfied();
        String txt = new String(Files.readAllBytes(this.testFile("outbox/" + TEST_FILE_NAME_RESULT)));
        Assertions.assertNotNull((Object)txt);
        String[] lines = txt.split(LS);
        Assertions.assertEquals((int)100, (int)lines.length, (String)"Should be 100 lines");
        LinkedHashSet<String> rows = new LinkedHashSet<String>(Arrays.asList(lines));
        Assertions.assertEquals((int)100, (int)rows.size(), (String)"Should be 100 unique lines");
        this.log.info(txt);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)this.from(FileConcurrentWriteAppendSameFileTest.this.fileUri("?initialDelay=0&delay=10")).routeId("foo").autoStartup(false).split((Expression)this.body().tokenize(LS)).parallelProcessing().streaming().setBody((Expression)this.body().append((Object)":Status=OK").append((Object)LS))).to(FileConcurrentWriteAppendSameFileTest.this.fileUri("outbox?fileExist=Append&fileName=" + TEST_FILE_NAME_RESULT))).to("mock:result")).end();
            }
        };
    }
}

