/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileBrowsableEndpointTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME_PREFIX = UUID.randomUUID().toString();

    @Test
    public void testBrowsableNoFiles() {
        BrowsableEndpoint browse = (BrowsableEndpoint)this.context.getEndpoint(this.fileUri("?initialDelay=0&delay=10"), BrowsableEndpoint.class);
        Assertions.assertNotNull((Object)browse);
        List list = browse.getExchanges();
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testBrowsableOneFile() {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"A", "CamelFileName", (Object)(TEST_FILE_NAME_PREFIX + "a.txt"));
        FileEndpoint endpoint = (FileEndpoint)this.context.getEndpoint(this.fileUri("?initialDelay=0&delay=10"), FileEndpoint.class);
        Assertions.assertNotNull((Object)endpoint);
        MemoryIdempotentRepository repo = (MemoryIdempotentRepository)endpoint.getInProgressRepository();
        Assertions.assertEquals((int)0, (int)repo.getCacheSize());
        List list = endpoint.getExchanges();
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)(TEST_FILE_NAME_PREFIX + "a.txt"), (Object)((Exchange)list.get(0)).getIn().getHeader("CamelFileName"));
        Assertions.assertEquals((int)0, (int)repo.getCacheSize());
        Assertions.assertTrue((boolean)Files.exists(this.testFile(TEST_FILE_NAME_PREFIX + "a.txt"), new LinkOption[0]), (String)"File should exist a.txt");
    }

    @Test
    public void testBrowsableTwoFiles() {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"A", "CamelFileName", (Object)(TEST_FILE_NAME_PREFIX + "a.txt"));
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"B", "CamelFileName", (Object)(TEST_FILE_NAME_PREFIX + "b.txt"));
        FileEndpoint endpoint = (FileEndpoint)this.context.getEndpoint(this.fileUri("?initialDelay=0&delay=10"), FileEndpoint.class);
        Assertions.assertNotNull((Object)endpoint);
        MemoryIdempotentRepository repo = (MemoryIdempotentRepository)endpoint.getInProgressRepository();
        Assertions.assertEquals((int)0, (int)repo.getCacheSize());
        List list = endpoint.getExchanges();
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals((int)0, (int)repo.getCacheSize());
        Assertions.assertTrue((boolean)Files.exists(this.testFile(TEST_FILE_NAME_PREFIX + "a.txt"), new LinkOption[0]), (String)"File should exist a.txt");
        Assertions.assertTrue((boolean)Files.exists(this.testFile(TEST_FILE_NAME_PREFIX + "b.txt"), new LinkOption[0]), (String)"File should exist b.txt");
    }

    @Test
    public void testBrowsableThreeFilesRecursive() {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"A", "CamelFileName", (Object)(TEST_FILE_NAME_PREFIX + "a.txt"));
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"B", "CamelFileName", (Object)("foo" + File.separator + TEST_FILE_NAME_PREFIX + "b.txt"));
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"C", "CamelFileName", (Object)("bar" + File.separator + TEST_FILE_NAME_PREFIX + "c.txt"));
        FileEndpoint endpoint = (FileEndpoint)this.context.getEndpoint(this.fileUri("?initialDelay=0&delay=10&recursive=true"), FileEndpoint.class);
        Assertions.assertNotNull((Object)endpoint);
        MemoryIdempotentRepository repo = (MemoryIdempotentRepository)endpoint.getInProgressRepository();
        Assertions.assertEquals((int)0, (int)repo.getCacheSize());
        List list = endpoint.getExchanges();
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((int)0, (int)repo.getCacheSize());
        Assertions.assertTrue((boolean)Files.exists(this.testFile(TEST_FILE_NAME_PREFIX + "a.txt"), new LinkOption[0]), (String)"File should exist a.txt");
        Assertions.assertTrue((boolean)Files.exists(this.testFile("foo" + File.separator + TEST_FILE_NAME_PREFIX + "b.txt"), new LinkOption[0]), (String)"File should exist foo/b.txt");
        Assertions.assertTrue((boolean)Files.exists(this.testFile("bar" + File.separator + TEST_FILE_NAME_PREFIX + "c.txt"), new LinkOption[0]), (String)"File should exist bar/c.txt");
    }
}

