/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileAbsolutePathIssueTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String FILE_SEPARATOR = File.separator;
    private String uri;
    private String start;
    private String done;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.start = this.testDirectory("issue").toAbsolutePath().toString();
        this.done = this.testDirectory("done").toAbsolutePath().toString();
        this.uri = "file:" + this.start + "?initialDelay=0&delay=10&move=" + this.done + FILE_SEPARATOR + "${file:name}";
        super.setUp();
    }

    @Test
    public void testMoveAbsolute() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.done + FILE_SEPARATOR + TEST_FILE_NAME);
        this.template.sendBodyAndHeader("file:" + this.start, (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileAbsolutePathIssueTest.this.uri).to("mock:result");
            }
        };
    }
}

