/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileAbsoluteAndRelativeConsumerTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello." + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testRelative() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:relative");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).header("CamelFileName")).isEqualTo((Object)("test" + File.separator + TEST_FILE_NAME));
        ((MockValueBuilder)mock.message(0).header("CamelFileNameOnly")).isEqualTo((Object)TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("filerelative"), (Object)"Hello World", "CamelFileName", (Object)("test/" + TEST_FILE_NAME));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAbsolute() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:absolute");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).header("CamelFileName")).isEqualTo((Object)("test" + File.separator + TEST_FILE_NAME));
        ((MockValueBuilder)mock.message(0).header("CamelFileNameOnly")).isEqualTo((Object)TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("fileabsolute"), (Object)"Hello World", "CamelFileName", (Object)("test/" + TEST_FILE_NAME));
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileAbsoluteAndRelativeConsumerTest.this.fileUri("filerelative?initialDelay=0&delay=10&recursive=true")).convertBodyTo(String.class)).to("mock:relative");
                ((RouteDefinition)this.from("file://" + String.valueOf(FileAbsoluteAndRelativeConsumerTest.this.testDirectory("fileabsolute").toAbsolutePath()) + "?initialDelay=0&delay=10&recursive=true").convertBodyTo(String.class)).to("mock:absolute");
            }
        };
    }
}

