/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DirectoryCreateIssueTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME_PREFIX = "file" + String.valueOf(UUID.randomUUID());
    private final int numFiles = 10;

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                String[] destinations = new String[10];
                for (int i = 0; i < 10; ++i) {
                    destinations[i] = "direct:file" + i;
                    ((RouteDefinition)this.from("direct:file" + i).setHeader("CamelFileName", (Expression)this.constant(TEST_FILE_NAME_PREFIX + i + ".txt"))).to(new String[]{DirectoryCreateIssueTest.this.fileUri("a/b/c/d/e/f/g/h/?fileExist=Override&noop=true"), "mock:result"});
                }
                this.from("seda:testFileCreatedAsDir").to(destinations);
            }
        };
    }

    @Test
    public void testFileCreatedAsDir() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(10);
        this.template.send("seda:testFileCreatedAsDir", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)"Contents of test file");
            }
        });
        this.assertMockEndpointsSatisfied();
        Awaitility.await().pollDelay(50L, TimeUnit.MILLISECONDS).untilAsserted(() -> {
            for (int i = 0; i < 10; ++i) {
                Assertions.assertTrue((boolean)Files.isRegularFile(this.testFile("a/b/c/d/e/f/g/h/" + TEST_FILE_NAME_PREFIX + i + ".txt"), new LinkOption[0]));
            }
        });
    }
}

