/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class BeanToFileTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "BeanToFileTest" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testBeanToFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.testFile(TEST_FILE_NAME), "Bye World");
        this.template.sendBody("direct:in", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)new MyBean());
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:in").to("bean:myBean")).setHeader("CamelFileName", (Expression)this.constant(TEST_FILE_NAME))).to(new String[]{BeanToFileTest.this.fileUri("?fileExist=Override"), "mock:result"});
            }
        };
    }

    public static class MyBean {
        public String doSomething(String input) {
            return "Bye " + input;
        }
    }
}

