/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.AntPathMatcherGenericFileFilter;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class AntPathMatcherGenericFileFilterTest
extends ContextTestSupport {
    private static final String TEST_DIR_NAME = "test" + String.valueOf(UUID.randomUUID());

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        AntPathMatcherGenericFileFilter filterNotCaseSensitive = new AntPathMatcherGenericFileFilter(new String[]{"**/c*"});
        filterNotCaseSensitive.setCaseSensitive(false);
        Registry jndi = super.createCamelRegistry();
        jndi.bind("filter", (Object)new AntPathMatcherGenericFileFilter(new String[]{"**/c*"}));
        jndi.bind("caseInsensitiveFilter", (Object)filterNotCaseSensitive);
        return jndi;
    }

    @Test
    public void testInclude() throws Exception {
        this.context.setAutoStartup(Boolean.valueOf(false));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(AntPathMatcherGenericFileFilterTest.this.fileUri(TEST_DIR_NAME + "/ant-path-1?initialDelay=0&delay=10&recursive=true&antInclude=**/*.txt&antFilterCaseSensitive=true")).convertBodyTo(String.class)).to("mock:result1");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result1");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World"});
        String endpointUri = this.fileUri(TEST_DIR_NAME + "/ant-path-1/x/y/z");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World", "CamelFileName", (Object)"report.txt");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 2", "CamelFileName", (Object)"b.TXT");
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testExclude() throws Exception {
        this.context.setAutoStartup(Boolean.valueOf(false));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(AntPathMatcherGenericFileFilterTest.this.fileUri(TEST_DIR_NAME + "/ant-path-2?initialDelay=0&delay=10&recursive=true&antExclude=**/*.bak")).convertBodyTo(String.class)).to("mock:result2");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result2");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World 2", "Hello World 3", "Hello World 4"});
        String endpointUri = this.fileUri(TEST_DIR_NAME + "/ant-path-2/x/y/z");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 1", "CamelFileName", (Object)"report.bak");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 2", "CamelFileName", (Object)"report.txt");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 3", "CamelFileName", (Object)"b.BAK");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 4", "CamelFileName", (Object)"b.TXT");
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testIncludesAndExcludes() throws Exception {
        this.context.setAutoStartup(Boolean.valueOf(false));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(AntPathMatcherGenericFileFilterTest.this.fileUri(TEST_DIR_NAME + "/ant-path-3?initialDelay=0&delay=10&recursive=true&antInclude=**/*.pdf,**/*.txt&antExclude=**/a*,**/b*")).convertBodyTo(String.class)).to("mock:result3");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result3");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World 2", "Hello World 4"});
        String endpointUri = this.fileUri(TEST_DIR_NAME + "/ant-path-3/x/y/z");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 1", "CamelFileName", (Object)"a.pdf");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 2", "CamelFileName", (Object)"m.pdf");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 3", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 4", "CamelFileName", (Object)"m.txt");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 5", "CamelFileName", (Object)"b.bak");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 6", "CamelFileName", (Object)"m.bak");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 7", "CamelFileName", (Object)"ay.PDF");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 8", "CamelFileName", (Object)"my.Pdf");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 9", "CamelFileName", (Object)"by.TXT");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 10", "CamelFileName", (Object)"my.TxT");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 11", "CamelFileName", (Object)"by.BAK");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 12", "CamelFileName", (Object)"my.BaK");
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testIncludesAndExcludesAndFilter() throws Exception {
        this.context.setAutoStartup(Boolean.valueOf(false));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(AntPathMatcherGenericFileFilterTest.this.fileUri(TEST_DIR_NAME + "/ant-path-4?initialDelay=0&delay=10&recursive=true&antInclude=**/*.txt&antExclude=**/a*&filter=#filter")).convertBodyTo(String.class)).to("mock:result4");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result4");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World 3"});
        String endpointUri = this.fileUri(TEST_DIR_NAME + "/ant-path-4/x/y/z");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 1", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 2", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 3", "CamelFileName", (Object)"c.txt");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 4", "CamelFileName", (Object)"Cy.txt");
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testIncludeAndAntFilterNotCaseSensitive() throws Exception {
        this.context.setAutoStartup(Boolean.valueOf(false));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(AntPathMatcherGenericFileFilterTest.this.fileUri(TEST_DIR_NAME + "/ant-path-5?initialDelay=0&delay=10&recursive=true&antInclude=**/*.txt&antFilterCaseSensitive=false")).convertBodyTo(String.class)).to("mock:result5");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result5");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World"});
        String endpointUri = this.fileUri(TEST_DIR_NAME + "/ant-path-5/x/y/z");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World", "CamelFileName", (Object)"report.TXT");
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testExcludeAndAntFilterNotCaseSensitive() throws Exception {
        this.context.setAutoStartup(Boolean.valueOf(false));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(AntPathMatcherGenericFileFilterTest.this.fileUri(TEST_DIR_NAME + "/ant-path-6?initialDelay=0&delay=10&recursive=true&antExclude=**/*.bak&antFilterCaseSensitive=false")).convertBodyTo(String.class)).to("mock:result6");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result6");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World 2", "Hello World 4"});
        String endpointUri = this.fileUri(TEST_DIR_NAME + "/ant-path-6/x/y/z");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 1", "CamelFileName", (Object)"report.bak");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 2", "CamelFileName", (Object)"report.txt");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 3", "CamelFileName", (Object)"b.BAK");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 4", "CamelFileName", (Object)"b.TXT");
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testIncludesAndExcludesAndAntFilterNotCaseSensitive() throws Exception {
        this.context.setAutoStartup(Boolean.valueOf(false));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(AntPathMatcherGenericFileFilterTest.this.fileUri(TEST_DIR_NAME + "/ant-path-7?initialDelay=0&delay=10&recursive=true&antInclude=**/*.Pdf,**/*.txt&antExclude=**/a*,**/b*&antFilterCaseSensitive=false")).convertBodyTo(String.class)).to("mock:result7");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result7");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World 2", "Hello World 4", "Hello World 8", "Hello World 10"});
        String endpointUri = this.fileUri(TEST_DIR_NAME + "/ant-path-7/x/y/z");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 1", "CamelFileName", (Object)"a.pdf");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 2", "CamelFileName", (Object)"m.pdf");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 3", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 4", "CamelFileName", (Object)"m.txt");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 5", "CamelFileName", (Object)"b.bak");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 6", "CamelFileName", (Object)"m.bak");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 7", "CamelFileName", (Object)"ay.PDF");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 8", "CamelFileName", (Object)"my.Pdf");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 9", "CamelFileName", (Object)"by.TXT");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 10", "CamelFileName", (Object)"my.TxT");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 11", "CamelFileName", (Object)"By.BAK");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 12", "CamelFileName", (Object)"My.BaK");
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testIncludesAndExcludesAndFilterAndAntFilterNotCaseSensitive() throws Exception {
        this.context.setAutoStartup(Boolean.valueOf(false));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(AntPathMatcherGenericFileFilterTest.this.fileUri(TEST_DIR_NAME + "/ant-path-8?initialDelay=0&delay=10&recursive=true&antInclude=**/*.txt&antExclude=**/a*&filter=#caseInsensitiveFilter")).convertBodyTo(String.class)).to("mock:result8");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result8");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World 3", "Hello World 4"});
        String endpointUri = this.fileUri(TEST_DIR_NAME + "/ant-path-8/x/y/z");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 1", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 2", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 3", "CamelFileName", (Object)"c.txt");
        this.template.sendBodyAndHeader(endpointUri, (Object)"Hello World 4", "CamelFileName", (Object)"Cy.txt");
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }
}

