/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.extension.verifier;

import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ComponentVerifierTest {
    @Test
    public void testGetErrorDetails() {
        ComponentVerifierExtension.VerificationError error = ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.asCode((String)"test_code"), (String)"test error desc").detail(ComponentVerifierExtension.VerificationError.asAttribute((String)"test_attr_1"), (Object)"test_detail_1").detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_CODE, (Object)"test_detail_2").build();
        Assertions.assertEquals((Object)"test_detail_1", (Object)error.getDetail(ComponentVerifierExtension.VerificationError.asAttribute((String)"test_attr_1")));
        Assertions.assertEquals((Object)"test_detail_1", (Object)error.getDetail("test_attr_1"));
        Assertions.assertEquals((Object)"test_detail_2", (Object)error.getDetail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_CODE));
        Assertions.assertNull((Object)error.getDetail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_TEXT));
        Assertions.assertNull((Object)error.getDetail(ComponentVerifierExtension.VerificationError.asAttribute((String)"test_attr_non_existant")));
    }

    @Test
    public void testNullCode() {
        IllegalArgumentException exp = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ComponentVerifierExtension.VerificationError.asCode(null), (String)"Code must not be null");
        Assertions.assertTrue((boolean)exp.getMessage().contains("null"));
    }

    @Test
    public void testNullAttribute() {
        IllegalArgumentException exp = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ComponentVerifierExtension.VerificationError.asAttribute(null), (String)"Attribute must not be null");
        Assertions.assertTrue((boolean)exp.getMessage().contains("null"));
    }

    @Test
    public void testScopeFromString() {
        Assertions.assertEquals((Object)ComponentVerifierExtension.Scope.PARAMETERS, (Object)ComponentVerifierExtension.Scope.fromString((String)"PaRaMeTeRS"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ComponentVerifierExtension.Scope.fromString((String)"unknown"));
    }
}

