/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class SendingToAlotOfDifferentDirectEndpointTest
extends ContextTestSupport {
    @Test
    public void testDirect() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(3);
        this.template.sendBody("seda:start", (Object)"Hello World");
        for (int i = 0; i < 1200; ++i) {
            this.context.getEndpoint("direct:bar-" + i);
        }
        this.template.sendBody("direct:foo", (Object)"Bye Moon");
        this.template.sendBody("seda:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:start").to("direct:foo");
                ((RouteDefinition)this.from("direct:foo").to("log:foo")).to("mock:foo");
            }
        };
    }
}

