/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DirectSynchronousTest {
    @Test
    public void testDirect() throws Exception {
        DefaultCamelContext container = new DefaultCamelContext();
        final AtomicBoolean invoked = new AtomicBoolean();
        container.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:test.a").to("direct:test.b");
                this.from("direct:test.b?synchronous=true").process(new Processor(){

                    public void process(Exchange e) {
                        invoked.set(true);
                    }
                });
                this.from("direct:test.c").to("direct:test.d?synchronous=true");
                this.from("direct:test.d").process(new Processor(){

                    public void process(Exchange e) {
                        invoked.set(true);
                    }
                });
            }
        });
        container.start();
        Endpoint endpoint = container.getEndpoint("direct:test.a");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("cheese", (Object)123);
        Producer producer = endpoint.createProducer();
        producer.process(exchange);
        Assertions.assertTrue((boolean)invoked.get(), (String)"Did not receive the message!");
        invoked.set(false);
        endpoint = container.getEndpoint("direct:test.c");
        exchange = endpoint.createExchange();
        exchange.getIn().setHeader("cake", (Object)456);
        producer = endpoint.createProducer();
        producer.process(exchange);
        Assertions.assertTrue((boolean)invoked.get(), (String)"Did not receive the message!");
        container.stop();
    }
}

