/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DirectShouldUseSameThreadTest
extends ContextTestSupport {
    private static long id;

    @Test
    public void testUseSameThread() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                final ThreadLocal local = new ThreadLocal();
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) {
                        local.set("Hello");
                        id = Thread.currentThread().getId();
                    }
                })).to("direct:foo");
                ((RouteDefinition)this.from("direct:foo").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"Hello", local.get());
                        Assertions.assertEquals((long)id, (long)Thread.currentThread().getId());
                    }
                })).to("mock:result");
            }
        };
    }
}

