/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.direct.DirectConsumerNotAvailableException;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=20L)
public class DirectProducerBlockingTest
extends ContextTestSupport {
    @Test
    public void testProducerBlocksForSuspendedConsumer() throws Exception {
        DirectEndpoint endpoint = this.getMandatoryEndpoint("direct:suspended", DirectEndpoint.class);
        endpoint.getConsumer().suspend();
        StopWatch watch = new StopWatch();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:suspended?block=true&timeout=500", (Object)"hello world"), (String)"Expected CamelExecutionException");
        DirectConsumerNotAvailableException cause = DirectProducerBlockingTest.assertIsInstanceOf(DirectConsumerNotAvailableException.class, e.getCause());
        DirectProducerBlockingTest.assertIsInstanceOf(CamelExchangeException.class, cause);
        Assertions.assertTrue((watch.taken() > 490L ? 1 : 0) != 0);
        Assertions.assertTrue((watch.taken() < 5000L ? 1 : 0) != 0);
    }

    @Test
    public void testProducerBlocksWithNoConsumers() throws Exception {
        DirectEndpoint endpoint = this.getMandatoryEndpoint("direct:suspended", DirectEndpoint.class);
        endpoint.getConsumer().suspend();
        StopWatch watch = new StopWatch();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start?block=true&timeout=500", (Object)"hello world"), (String)"Expected CamelExecutionException");
        DirectConsumerNotAvailableException cause = DirectProducerBlockingTest.assertIsInstanceOf(DirectConsumerNotAvailableException.class, e.getCause());
        DirectProducerBlockingTest.assertIsInstanceOf(CamelExchangeException.class, cause);
        Assertions.assertTrue((watch.taken() > 490L ? 1 : 0) != 0);
        Assertions.assertTrue((watch.taken() < 5000L ? 1 : 0) != 0);
    }

    @Test
    public void testProducerBlocksResumeTest() throws Exception {
        this.context.getRouteController().suspendRoute("foo");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                    DirectProducerBlockingTest.this.log.info("Resuming consumer");
                    DirectProducerBlockingTest.this.context.getRouteController().resumeRoute("foo");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:suspended?block=true&timeout=1000", (Object)"hello world");
        this.assertMockEndpointsSatisfied();
        executor.shutdownNow();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:suspended").routeId("foo").to("mock:result");
            }
        };
    }
}

