/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.component.direct.DirectConsumerNotAvailableException;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DirectNoConsumerTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testInOnly() throws Exception {
        ((DirectComponent)this.context.getComponent("direct", DirectComponent.class)).setBlock(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("direct:foo");
            }
        });
        this.context.start();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should throw an exception");
        DirectNoConsumerTest.assertIsInstanceOf(DirectConsumerNotAvailableException.class, e.getCause());
    }

    @Test
    public void testInOut() throws Exception {
        ((DirectComponent)this.context.getComponent("direct", DirectComponent.class)).setBlock(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("direct:foo");
            }
        });
        this.context.start();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.requestBody("direct:start", (Object)"Hello World"), (String)"Should throw an exception");
        DirectNoConsumerTest.assertIsInstanceOf(DirectConsumerNotAvailableException.class, e.getCause());
    }

    @Test
    public void testFailIfNoConsumerFalse() throws Exception {
        ((DirectComponent)this.context.getComponent("direct", DirectComponent.class)).setBlock(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("direct:foo?failIfNoConsumers=false");
            }
        });
        this.context.start();
        this.template.sendBody("direct:start", (Object)"Hello World");
    }

    @Test
    public void testWireTapFailIfNoConsumerFalse() throws Exception {
        ((DirectComponent)this.context.getComponent("direct", DirectComponent.class)).setBlock(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").wireTap("direct:foo?failIfNoConsumers=false").to("mock:foo");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFailIfNoConsumersAfterConsumersLeave() throws Exception {
        ((DirectComponent)this.context.getComponent("direct", DirectComponent.class)).setBlock(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:foo").routeId("stopThisRoute").to("mock:foo");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.getRouteController().stopRoute("stopThisRoute");
        TimeUnit.MILLISECONDS.sleep(100L);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:foo", (Object)"Hello World"), (String)"Should have thrown an exception");
        DirectNoConsumerTest.assertIsInstanceOf(DirectConsumerNotAvailableException.class, e.getCause());
    }

    @Test
    public void testFailIfNoConsumersWithValidConsumer() throws Exception {
        ((DirectComponent)this.context.getComponent("direct", DirectComponent.class)).setBlock(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:in").to("direct:foo");
                this.from("direct:foo").to("mock:foo");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:in", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFailIfNoConsumersFalseWithPipeline() throws Exception {
        ((DirectComponent)this.context.getComponent("direct", DirectComponent.class)).setBlock(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:in").to("direct:foo?failIfNoConsumers=false")).to("direct:bar");
                this.from("direct:bar").to("mock:foo");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:in", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConfigOnAConsumer() throws Exception {
        ((DirectComponent)this.context.getComponent("direct", DirectComponent.class)).setBlock(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:foo?failIfNoConsumers=false").to("log:test");
            }
        });
        this.context.start();
    }
}

