/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DirectEndpointRouteInlinedTest
extends ContextTestSupport {
    @Test
    public void testDirect() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        });
        this.context.start();
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDirectExistingExists() {
        FailedToStartRouteException e = (FailedToStartRouteException)Assertions.assertThrows(FailedToStartRouteException.class, () -> this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
                this.from("direct:start").to("mock:bar");
            }
        }), (String)"Should have thrown exception");
        Assertions.assertTrue((boolean)e.getMessage().matches("Failed to start route route[0-9]+ because of Multiple consumers for the same endpoint is not allowed: direct://start"));
    }
}

